package org.injac.cocoon.actions;

//**************** imports log4j ****************
import java.io.IOException;
import java.rmi.ServerException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.w3c.dom.Element;


import org.injac.utils.*;

/**
 * Cocoon framework implementation
 * <p>Action performing a webdav querie on a single resource to retrieve specified metadatas.
 * Returns metadatas as sitemap variables named by specified parameters.
 *  Parameters to feed this action with are :
 * 
 * <blockquote>
 *  <dl>
 *  <dt> webdav-path </dt>
 *  <dd> root path </dd>
 * 	<dt> path </dt>
 *  <dd> relative path to actual resource to query </dd>
 *  <dt> reqparams </dt>
 *  <dd> list of metadas to retrieve separated by space(see sample below).</dd>
 *  </dl>
 * </blockquote>
 * <blockquote>
 *  <dt> Sitemap sample :</dt>
 * 	
 * <dd>&lt;map:actions&gt;</dd>
 * <dd>		&lt;map:action name="metadata-action" src="org.injac.cocoon.actions.MetaAction"/&gt;</dd>
 * <dd>&lt;/map:actions&gt;</dd>
 * <dd>...</dd>
 * <dd>&lt;map:match pattern="GetMD"&gt;</dd>
 * <dd>	&lt;map:act type="metadata-action"&gt;</dd>
 * <dd>		&lt;map:parameter name="webdav-path" value="{iconf:/iconf/webdav}" /&gt;</dd>
 * <dd>			&lt;map:parameter name="path" value="{request-param:path}" /&gt;</dd>
 * <dd>			&lt;map:parameter name="reqparams" value="DAV:modificationdate INJAC:title INJAC:CSSFile" /&gt;</dd>
 * <dd>			&lt;map:generate  src="cocoon:/MD?title={title}&amp;CSSFile={CSSFile}"/&gt;</dd>
 * <dd>		&lt;/map:act&gt;</dd>
 * <dd>		&lt;map:serialize/&gt;</dd>
 * <dd>	&lt;/map:match&gt;</dd>
 * 
 * </p>
 * 
 * @author <a href="mailto:f.jannin@etu.enseeiht.fr">Franois Jannin</a>
 *         (ENSEEIHT)
 * @version 1.0
 */
public class MetaAction extends AbstractAction {

	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(MetaAction.class);
	
	/**
	 * The dav ressource uri
	 */
	private String webdavpath;
	/**
	 * path for retrieving MD
	 */
	private String path;
	/**
	 * root node ex : /slide/file/injacRoot
	 */
	private String rootpath;
	/**
	 * Credentials
	 */
	private String login;
	private String password;
	/**
	 * Vector with requested MD name
	 */
	private Vector mdVector;
	/**
	 * Connection with session management
	 */
	private WebdavConnection webdavConnection;
	
	public Map act (Redirector redirector, 
            SourceResolver resolver, 
            Map objectModel, 
            String source, 
            Parameters params) throws Exception{
		
		String reqparams;
		// internal instances
		mdVector = new Vector();
		webdavConnection = new WebdavConnection(objectModel);
		// local instances
		Map sitemapParams = new HashMap();
		try {
			webdavpath= (String)params.getParameter("webdav-path");			
			path= (String)params.getParameter("path");
			rootpath = webdavpath.substring(webdavpath.indexOf("/slide"));
			if((path==null) || path.equals(""))
				path="";
			try {
				reqparams=(String)params.getParameter("reqparams");
				// parsing of required MD
				logger.debug("reqparams: "+reqparams);
            	if(reqparams.equals(""))
            	{
            		// default MDs
    				logger.debug("reqparams: vide");
                	mdVector.add("INJAC:title");
                    mdVector.add("INJAC:CSSFile");
            		
            	}else
            	{
            		for(StringTokenizer ST = new StringTokenizer(reqparams, " ");ST.hasMoreTokens(); )
            		{
            			mdVector.add(ST.nextToken());
            		}
            	}
				
			}catch(ParameterException pe)
			{
				// default MDs
				logger.debug("reqparams: null");
            	mdVector.add("INJAC:title");
                mdVector.add("INJAC:CSSFile");
			}
			// fetch credentials
			try {
				login=(String)params.getParameter("login");
				password=(String)params.getParameter("password");
			}
			catch(Exception e)
			{
				login=null;
				password=null;
			}
			
			if(webdavpath != null)
			{
				logger.debug("connecting to webdav-path : "+webdavpath+"\npath : "+path);
				connect(webdavpath);
               	logger.debug("MetaAction::Act : connection ressource okay");
			}
			else
			{
				String msg = "MetaAction::act : no path as argument.\n missing parameter : webdav-path";
				logger.error(msg);
				throw new Exception(msg);
			}
			
		} catch (Exception e) {
			
			throw new Exception("MetaAction::act : problme de paramtres.\n webdavpath :"+webdavpath+"\nlogin: "+login, e);
			
		}
		buildResponse(sitemapParams);
		logger.debug("MetaAction::Act : connection ressource "+webdavpath+ " ok"+"\nresult : "+sitemapParams);
		
		return sitemapParams;
	}
	
	void parseProperty(Property prop, Map sitemapParams)
	{
		Element el=prop.getElement();
		String tagname =el.getNodeName();
		// cas o l'lment n'a pas de contenu
		String value="";
		if(el.hasChildNodes())
			value=el.getFirstChild().getNodeValue();
		String mapname=tagname.substring(tagname.indexOf(":")+1);
		sitemapParams.put(mapname, value);
		logger.debug("tagname : "+tagname+" mapname : "+mapname+" value : "+value);	
	
	}
	
	
	
	public void buildResponse(Map sitemapParams)throws Exception
	{
		Enumeration resp_enum=null;
	    
        Enumeration md = getProperties(mdVector);
		try
		{
			int i=0;
			logger.debug("MetaAction::buildResponse : PropFind methode ok");           
			while(md.hasMoreElements())
			{
				Object resp_element =md.nextElement();
				logger.debug("class resp_element : "+resp_element.getClass()+" resp_element.toString : "+resp_element.toString());
				if(resp_element.getClass().getName().equals("org.apache.webdav.lib.BaseProperty"))
				{
					logger.debug("property : ");
					org.apache.webdav.lib.BaseProperty prop = (org.apache.webdav.lib.BaseProperty)resp_element;
					logger.debug("--> : "+prop);
					parseProperty(prop, sitemapParams);
					logger.debug("parseProperty ok");
					i=1;
				}
				else
				{	
					XMLResponseMethodBase.Response resp= (XMLResponseMethodBase.Response)resp_element;
					Enumeration properties =resp.getProperties();
					while(properties.hasMoreElements())
					{
						Property prop = (Property)properties.nextElement();
						parseProperty(prop, sitemapParams);
					}
					i++;
				}
            }
            sitemapParams.put("nbmd", ""+i);
            logger.debug("first level enum count  : "+i);
		}catch (Exception e) {
			logger.error("MetaAction::buildResponse : "+e.getMessage());
			throw new Exception("MetaAction::buildResponse : impossible de retrouver les mtadonnes.\n webdavpath :"+webdavpath, e);
		}
	}
		

	
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	private void connect(String connexionString) throws Exception
	{
		logger.debug("ConnexionString : "+ connexionString);
		try 
		{
				if((login!=null) && (password!=null))
				{	
					webdavConnection.connect(connexionString, login, password);	
				}
				else
				{
					webdavConnection.connect(connexionString);	
				}
			}
		catch (Exception ex) 
		{	
			logger.error("error connecting to webdav resource : "+ connexionString+"\ncause : "+ex.getCause());	
	        throw ex;
	    }
		logger.debug("Connect : end");	
	}

	private String GetProxyTicket()
	{
		//ProxyTicketReceptor ptr = (ProxyTicketReceptor);
        //getServletConfig().getServletContext().getServlet("bookdb");
		return null;
	}
	
	/**
	 * Give the property of resource
	 * @return the array of properties
	 */
	private Enumeration getProperties(Vector properties) throws URIException, IOException 
	{
		logger.debug("properties :"+ properties);
		logger.debug("PROPFIND webdavpath :"+ webdavpath);
		logger.debug("PROPFIND path :"+ path);
		logger.debug("PROPFIND rootpath :"+ rootpath);
		logger.debug("PROPFIND propfindpath :"+ rootpath+path);
		
		return webdavConnection.getProperties(rootpath+path, DepthSupport.DEPTH_0, properties);
	}
}
